/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.client.dynpack;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.IGeneratedBlockstate;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingStateProvider;

public final class DynamicBlockStates
extends BlockStateProvider {
    private final Map<ResourceLocation, String> cache;

    public DynamicBlockStates(Map<ResourceLocation, String> cache) {
        super(new DataGenerator(Path.of("", new String[0]), List.of()), "buddingcrystals", new ExistingFileHelper(List.of(), Set.of(), false, null, null));
        this.cache = cache;
    }

    protected void registerStatesAndModels() {
        BCContent.loadedSets().forEach(set -> BuddingStateProvider.makeModels(this, set));
    }

    public void m_6865_(HashCache cache) {
        try {
            Method clear = ObfuscationReflectionHelper.findMethod(ModelProvider.class, (String)"clear", (Class[])new Class[0]);
            clear.invoke((Object)this.models(), new Object[0]);
            clear.invoke((Object)this.itemModels(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.registeredBlocks.clear();
        this.registerStatesAndModels();
        this.models().generatedModels.values().forEach(builder -> {
            ResourceLocation modelName = builder.getLocation();
            ResourceLocation modelLocation = new ResourceLocation(modelName.m_135827_(), "models/" + modelName.m_135815_() + ".json");
            this.cache.put(modelLocation, builder.toJson().toString());
        });
        this.itemModels().generatedModels.values().forEach(builder -> {
            ResourceLocation modelName = builder.getLocation();
            ResourceLocation modelLocation = new ResourceLocation(modelName.m_135827_(), "models/" + modelName.m_135815_() + ".json");
            this.cache.put(modelLocation, builder.toJson().toString());
        });
        for (Map.Entry entry : this.registeredBlocks.entrySet()) {
            ResourceLocation blockName = (ResourceLocation)Preconditions.checkNotNull((Object)((Block)entry.getKey()).getRegistryName());
            ResourceLocation stateLocation = new ResourceLocation(blockName.m_135827_(), "blockstates/" + blockName.m_135815_() + ".json");
            this.cache.put(stateLocation, ((IGeneratedBlockstate)entry.getValue()).toJson().toString());
        }
    }
}

